<?php
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

Route::post('auth/register', [\App\Http\Controllers\AuthController::class, 'create']);
Route::post('auth/login', [\App\Http\Controllers\AuthController::class, 'login']);
Route::post('auth/login/pin', [\App\Http\Controllers\AuthController::class, 'loginByPin']);

Route::middleware('guard:sanctum')->group(function () {
    // public routes for products
    Route::get('store/products', [\App\Http\Controllers\ProductController::class, 'indexPublic']);
    Route::get('store/products/{product:slug}', [\App\Http\Controllers\ProductController::class, 'showPublic']);
    // public routes for categories
    Route::get('store/categories', [\App\Http\Controllers\CategoryController::class, 'indexPublic']);
    Route::get('store/categories/{category:slug}', [\App\Http\Controllers\CategoryController::class, 'showPublic']);
    // public routes for colors
    Route::get('store/colors', [\App\Http\Controllers\ColorController::class, 'indexPublic']);
    // public routes for customers
    Route::get('store/customers', [\App\Http\Controllers\CustomerController::class, 'indexPublic']);
    Route::post('store/customers', [\App\Http\Controllers\CustomerController::class, 'storePublic']);
    // public routes for users
    Route::get('store/users', [\App\Http\Controllers\UserController::class, 'indexPublic']);
    // public routes for sales
    Route::get('store/sales/{sale}', [\App\Http\Controllers\Sales\SaleController::class, 'showPublic']);
    Route::post('store/sales', [\App\Http\Controllers\Sales\SaleController::class, 'storePublic']);

    // public routes for coupons
    Route::get("coupons/code/{coupon:code}", [\App\Http\Controllers\CouponController::class, 'show']);

    Route::post("store/newsletter", [\App\Http\Controllers\NewsletterController::class, 'store']);

});

// route for populate slugs
Route::get('populate-slugs', function () {
    $products = \App\Models\Product::all();
    foreach ($products as $product) {
        $product->slug = \Str::slug($product->name);
        $product->save();
    }
    return response()->json([
        'success' => true,
        'message' => 'Slugs populated'
    ], 200);

});

// Private routes
Route::middleware('auth:sanctum')->group(function () {
    // auth
    Route::get('auth/logout', [\App\Http\Controllers\AuthController::class, 'logout']);
    Route::get('auth/check-session', [\App\Http\Controllers\AuthController::class, 'checkSession']);
    Route::put('auth/change-credentials', [\App\Http\Controllers\AuthController::class, 'changeCredentials']);
    Route::put('auth/profile', [\App\Http\Controllers\AuthController::class, 'updateProfileInfo']);

    // users
    Route::apiResource("users", \App\Http\Controllers\UserController::class);
    Route::post("users/commissions", [\App\Http\Controllers\UserController::class, 'commissionsBySeller']);

    // categories
    Route::apiResource("categories", \App\Http\Controllers\CategoryController::class);

    // subcategories
    Route::apiResource("subcategories", \App\Http\Controllers\SubcategoryController::class);

    // colors
    Route::apiResource("colors", \App\Http\Controllers\ColorController::class);

    // sizes
    Route::apiResource("sizes", \App\Http\Controllers\SizeController::class);

    // pricetypes
    Route::apiResource("pricetypes", \App\Http\Controllers\PricetypeController::class);

    // stocks
    Route::apiResource("stock", \App\Http\Controllers\StockController::class);

    //products
    Route::get("products/search", [\App\Http\Controllers\ProductController::class, 'searchProduct']);
    Route::apiResource("products", \App\Http\Controllers\ProductController::class);
    Route::patch("store/products/{product:slug}/mark-as-favorite", [\App\Http\Controllers\ProductController::class, 'markAsFavorite']);

    // files
    Route::post("files/multiple", [\App\Http\Controllers\FileController::class, 'multiple']);
    Route::apiResource("files", \App\Http\Controllers\FileController::class);

    // Customers
    Route::apiResource("customers", \App\Http\Controllers\CustomerController::class);

    // Sales
    Route::apiResource("sales", \App\Http\Controllers\Sales\SaleController::class);
    Route::put("sales/{sale}/payments", [\App\Http\Controllers\Sales\SaleController::class, 'addPaymentToSale']);
    Route::post("sales/{sale}/details", [\App\Http\Controllers\Sales\SaleDetailController::class, 'addSaleDetail']);
    Route::put("sales/{sale}/details/{sale_detail}", [\App\Http\Controllers\Sales\SaleDetailController::class, 'updateSaleDetail']);
    Route::delete("sales/{sale}/details/{sale_detail}", [\App\Http\Controllers\Sales\SaleDetailController::class, 'destroySaleDetail']);
    Route::get("store/sales", [\App\Http\Controllers\Sales\SaleController::class, 'indexPublic']);
    Route::post("sales/create-sale", [\App\Http\Controllers\Sales\CreateSaleController::class, 'createSale']);
    Route::post("sales/{sale}/refund", [\App\Http\Controllers\Sales\SaleRefundController::class, 'markAsRefund']);

    // Coupons
    Route::apiResource("coupons", \App\Http\Controllers\CouponController::class);

    // banks
    Route::apiResource("banks", \App\Http\Controllers\BankController::class);

    // config variables
    Route::apiResource("config-variables", \App\Http\Controllers\ConfigVariableController::class);

    // newsletters
    Route::apiResource("newsletters", \App\Http\Controllers\NewsletterController::class);
});