<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('sale_details', function (Blueprint $table) {
            $table->id();
            $table->integer('quantity');
            $table->bigInteger('product_id')->unsigned()->nullable();
            $table->decimal('total', 10, 2);
            $table->bigInteger('sale_id')->unsigned()->nullable();
            $table->foreign('product_id')
                ->references('id')->on('products')->onDelete('set null');
            $table->foreign('sale_id')
                ->references('id')->on('sales')->onDelete('set null');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('sale_details');
    }
};
