<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('pricetype_product', function (Blueprint $table) {
            $table->decimal('price', 10, 2);
            $table->bigInteger('product_id')->unsigned()->nullable();
            $table->bigInteger('pricetype_id')->unsigned()->nullable();
            $table->primary(['product_id', 'pricetype_id']);
            $table->foreign('product_id')->references('id')->on('products')->onDelete('cascade');
            $table->foreign('pricetype_id')->references('id')->on('pricetypes')->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('pricetype_product');
    }
};