<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Sale extends Model
{
    use HasFactory;
    protected $fillable = [
        'customer_id',
        'total',
        'user_id',
        'sale_type',
        'payment_type',
        'pricetype_id',
        'bank_id',
        'sale_category',
        'shipping_total',
        'coupon_id',
        'status',
        'balance_used',
        'use_balance',
        'amount_refunded',
        'pending_applied_to_balance',
    ];

    protected $casts = [
        'total' => 'float',
        'shipping_total' => 'float',
        'balance_used' => 'float',
        'amount_refunded' => 'float',
        'use_balance' => 'boolean',
        'pending_applied_to_balance' => 'boolean',

    ];

    protected $appends = [
        'pending_total',
    ];

    public function getPendingTotalAttribute()
    {
        // \Log::info($this->total);

        $totalPaid = $this->banks->sum(function ($bankSale) {
            \Log::info($bankSale->pivot->amount);
            return $bankSale->pivot->amount;
        });

        return ($this->total - $this->balance_used - $this->amount_refunded) - $totalPaid;
    }
    public function customer()
    {
        return $this->belongsTo(Customer::class);
    }
    public function user()
    {
        return $this->belongsTo(User::class);
    }
    public function sale_details()
    {
        return $this->hasMany(Sale_detail::class);
    }
    public function pricetype()
    {
        return $this->belongsTo(Pricetype::class);
    }

    public function bank()
    {
        return $this->belongsTo(Bank::class);
    }

    public function banks()
    {
        return $this->belongsToMany(Bank::class)->withPivot(['amount', 'id'])->withTimestamps();
    }

    public function coupon()
    {
        return $this->belongsTo(Coupon::class);
    }
}
