<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class File extends Model
{
    use HasFactory;

    protected $fillable = ['path', 'name', 'mime_type'];

    public function products()
    {
        return $this->belongsToMany(Product::class)->withTimestamps()->withPivot('stock_id');
    }

    public function stocks()
    {
        return $this->belongsToMany(Stock::class, 'file_product')->withTimestamps()->withPivot('product_id');
    }

    public function categories()
    {
        return $this->hasMany(Category::class);
    }
}
