<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Customer extends Model
{
    use HasFactory;
    protected $fillable = [
        'name',
        'phone_number',
        'address',
        'pricetype_id',
        'has_credit',
        'created_by',
        'type',
        'balance'
    ];
    protected $casts = [
        'has_credit' => 'boolean',
        'balance' => 'float'
    ];
    public function sales()
    {
        return $this->hasMany(Sale::class);
    }
    public function pricetype()
    {
        return $this->belongsTo(Pricetype::class);
    }
    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function favoriteProducts()
    {
        return $this->belongsToMany(Product::class, 'favorite_products');
    }
}
