<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Bank extends Model
{
    use HasFactory;
    protected $fillable = [
        'bank_name',
        'account_alias',
        'card_number',
        'account_number',
        'interbank_key',
    ];

    public function sales()
    {
        return $this->belongsToMany(Sale::class)->withPivot('amount')->withTimestamps();
    }
}
