<?php
namespace App\Http\Services;

use App\Models\User;
use App\Models\Newsletter;

class NewsletterService
{
    public static function getNewsletters(): array
    {
        return Newsletter::all()->toArray();
    }

    public static function getNewsletter(int $id): Newsletter
    {
        return Newsletter::findOrFail($id);
    }
    public static function createNewsletter(array $data): Newsletter
    {
        $newsletter = new Newsletter();
        $newsletter->email = $data['email'];
        $newsletter->save();


        return $newsletter;
    }


    public static function updateNewsletter(Newsletter $newsletter, array $data): Newsletter
    {
        $newsletter->email = $data['email'];
        $newsletter->save();
        return $newsletter;
    }

    public static function deleteNewsletter(Newsletter $newsletter): bool
    {
        return $newsletter->delete();
    }


}