<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class CreateSaleRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'total' => 'required|numeric',
            'sale_type' => 'required|string',
            'payment_type' => 'required|string',
            'customer_id' => 'nullable|exists:customers,id',
            'user_id' => 'nullable|exists:users,id',
            'pricetype_id' => 'nullable|exists:pricetypes,id',
            'sale_category' => 'nullable|string:purchase,quotation,layaway',
            'shipping_total' => 'required|numeric',
            'coupon_id' => 'nullable|exists:coupons,id',
            'use_balance' => 'nullable|boolean',
            'apply_pending_to_balance' => 'nullable|boolean',
            'sale_details.*' => 'required|array',
            'sale_details.*.quantity' => 'required|integer',
            'sale_details.*.price' => 'required|numeric',
            'sale_details.*.product_id' => 'required|exists:products,id',
            'sale_details.*.product' => 'required|array',
            'sale_details.*.stock_id' => 'nullable|exists:stocks,id',
            'banks.*' => 'nullable|array',
            'banks.*.bank_id' => 'required|exists:banks,id',
            'banks.*.amount' => 'required|numeric',
        ];
    }
}
