<?php

namespace App\Http\Controllers;

use App\Models\Size;
use Illuminate\Http\Request;

class SizeController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $sizes = Size::all();

        return response()->json([
            'success' => true,
            'data' => $sizes,
        ], 200);
    }

    public function indexPublic()
    {
        $sizes = Size::all();

        return response()->json([
            'success' => true,
            'data' => $sizes,
        ], 200);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $rules = [
            'name' => 'required|string',
        ];

        $validator = \Validator::make($request->input(), $rules);

        if ($validator->fails()) {
            return response()->json([
                'success' => false,
                'message' => 'Validation error',
                'errors' => $validator->errors()
            ], 400);
        }

        $data = $validator->validated();


        $size = Size::create($data);

        return response()->json([
            'success' => true,
            'data' => $size,
        ], 201);
    }

    /**
     * Display the specified resource.
     */
    public function show(Size $size)
    {
        return response()->json([
            'success' => true,
            'data' => $size,
        ]);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, Size $size)
    {
        $rules = [
            'name' => 'required|string',
        ];

        $validator = \Validator::make($request->input(), $rules);

        if ($validator->fails()) {
            return response()->json([
                'success' => false,
                'message' => 'Validation error',
                'errors' => $validator->errors()
            ], 400);
        }

        $data = $validator->validated();

        $size->update($data);

        return response()->json([
            'success' => true,
            'data' => $size,
        ], 200);
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Size $size)
    {
        $deleted = $size->delete();
        $responseCode = $deleted ? 200 : 404;
        $message = $deleted ? 'Size deleted' : 'Size not found';
        $success = $deleted ? true : false;

        return response()->json(
            [
                'success' => $success,
                "message" => $message,
                'data' => $size,
            ],
            $responseCode
        );
    }
}
