<?php

namespace App\Http\Controllers\Sales;

use App\Http\Controllers\Controller;
use App\Http\Requests\CreateRefundRequest;
use App\Models\Sale;
use Illuminate\Http\JsonResponse;

class SaleRefundController extends Controller
{
    public function markAsRefund(CreateRefundRequest $request, Sale $sale): JsonResponse
    {

        if ($sale->status === 'refunded' && $sale->amount_refunded === $sale->total) {
            abort(400, 'El total de la venta ya ha sido devuelto');
        }

        if ($sale->total - $sale->amount_refunded < $request->amount) {
            abort(400, 'El monto a devolver es mayor al monto total de la venta');
        }

        \DB::beginTransaction();

        try {
            $is_updated = $sale->update([
                'status' => 'refunded',
                'amount_refunded' => $sale->amount_refunded + $request->amount
            ]);

            $customer = $sale->load('customer')->customer;

            $customer->update([
                'balance' => $customer->balance + $request->amount
            ]);

            if (!$is_updated) {
                abort(400, 'Error al marcar la venta como devuelta');
            }

            \DB::commit();

            return response()->json([
                'success' => true,
                'message' => 'Venta marcada como devuelta',
                'data' => $sale
            ]);
        } catch (\Throwable $th) {
            \DB::rollBack();
            abort(400, 'Error al marcar la venta como devuelta');
        }

    }

}