<?php

namespace App\Http\Controllers;

use App\Models\Pricetype;
use Illuminate\Http\Request;

class PricetypeController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $pricetypes = Pricetype::all();

        return response()->json([
            'success' => true,
            'data' => $pricetypes,
        ], 200);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $rules = [
            'name' => 'required|string',
        ];

        $validator = \Validator::make($request->input(), $rules);

        if ($validator->fails()) {
            return response()->json([
                'success' => false,
                'message' => 'Validation error',
                'errors' => $validator->errors()
            ], 400);
        }

        $data = $validator->validated();


        $pricetypes = Pricetype::create($data);

        return response()->json([
            'success' => true,
            'data' => $pricetypes,
        ], 201);
    }

    /**
     * Display the specified resource.
     */
    public function show(Pricetype $pricetype)
    {
        return response()->json([
            'success' => true,
            'data' => $pricetype,
        ]);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, Pricetype $pricetype)
    {
        $rules = [
            'name' => 'required|string',
        ];

        $validator = \Validator::make($request->input(), $rules);

        if ($validator->fails()) {
            return response()->json([
                'success' => false,
                'message' => 'Validation error',
                'errors' => $validator->errors()
            ], 400);
        }

        $data = $validator->validated();

        $pricetype->update($data);

        return response()->json([
            'success' => true,
            'data' => $pricetype,
        ], 200);
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Pricetype $pricetype)
    {
        $deleted = $pricetype->delete();
        $responseCode = $deleted ? 200 : 404;
        $message = $deleted ? 'Pricetype deleted' : 'Pricetype not found';
        $success = $deleted ? true : false;

        return response()->json(
            [
                'success' => $success,
                "message" => $message,
                'data' => $pricetype,
            ],
            $responseCode
        );
    }
}