<?php

namespace App\Http\Controllers;

use App\Models\Product;
use Illuminate\Http\Request;
use PDF;

class PDFController extends Controller
{
    public function generateHtmlToPDF()
    {
        $query = Product::with(['files', 'stocks']);

        if (request()->has('category_id')) {
            $query->where('category_id', request('category_id'));
        }

        if (request()->has('subcategory_id')) {
            $query->where('subcategory_id', request('subcategory_id'));
        }

        // where has at least one file
        $query->whereHas('files');

        $query->whereHas('stocks', function ($q) {
            $q->where('stock', '>', 0);
        });


        $data['products'] = $query->get();

        $pdf = PDF::loadView('product-peer-page', $data);

        $pdf->setBasePath(public_path());

        return $pdf->download("ramadi-".date('Y-m-d').".pdf");

    }
}
