<?php

namespace App\Http\Controllers;

use App\Http\Services\NewsletterService;
use App\Models\Newsletter;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;

class NewsletterController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index(): JsonResponse
    {
        $newsletters = NewsletterService::getNewsletters();

        return response()->json([
            'success' => true,
            'data' => $newsletters,
        ]);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $rules = [
            'email' => 'required|email|unique:newsletters,email',
        ];

        $validator = \Validator::make($request->all(), $rules);


        if ($validator->fails()) {
            return response()->json([
                'success' => false,
                'errors' => $validator->errors(),
            ]);
        }

        $data = $validator->validated();

        $newsletter = NewsletterService::createNewsletter($data);

        return response()->json([
            'success' => true,
            'data' => $newsletter,
        ]);
    }

    /**
     * Display the specified resource.
     */
    public function show(Newsletter $newsletter)
    {
        return response()->json([
            'success' => true,
            'data' => $newsletter,
        ]);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, Newsletter $newsletter)
    {
        $rules = [
            'email' => 'required|email|unique:newsletters,email,' . $newsletter->id,
        ];

        $validator = \Validator::make($request->all(), $rules);

        if ($validator->fails()) {
            return response()->json([
                'success' => false,
                'errors' => $validator->errors(),
            ]);
        }

        $data = $validator->validated();

        $newsletter = NewsletterService::updateNewsletter($newsletter, $data);

        return response()->json([
            'success' => true,
            'data' => $newsletter,
        ]);
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Newsletter $newsletter)
    {
        $deleted = NewsletterService::deleteNewsletter($newsletter);

        return response()->json([
            'success' => $deleted,
            'data' => $newsletter,
        ]);
    }
}
