<?php

namespace App\Http\Controllers;

use App\Models\Coupon;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;

class CouponController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index(): JsonResponse
    {
        $query = Coupon::query();

        $coupons = $query->get();

        return response()->json([
            'success' => true,
            'data' => $coupons,
        ]);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request): JsonResponse
    {
        $rules = [
            'code' => 'required|unique:coupons,code',
            'type' => 'required|in:fixed,percent',
            'value' => 'required|numeric',
            'use_limit' => 'nullable|numeric',
            'expires_at' => 'nullable|date',
            'status' => 'required|in:active,inactive',
        ];

        $validator = \Validator::make($request->all(), $rules);



        if ($validator->fails()) {
            return response()->json([
                'success' => false,
                'message' => 'Validation error',
                'errors' => $validator->errors()
            ]);
        }

        $user = auth()->user();

        $data = $validator->validated();

        $coupon = Coupon::create(
            [
                ...$data,
                'createdBy' => $user->id,
            ],
        );

        return response()->json([
            'success' => true,
            'data' => $coupon,
        ]);
    }

    /**
     * Display the specified resource.
     */
    public function show(Coupon $coupon): JsonResponse
    {
        return response()->json([
            'success' => true,
            'data' => $coupon,
        ]);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, Coupon $coupon): JsonResponse
    {
        $rules = [
            'code' => 'required|unique:coupons,code,' . $coupon->id,
            'type' => 'required|in:fixed,percent',
            'value' => 'required|numeric',
            'use_limit' => 'nullable|numeric',
            'expires_at' => 'nullable|date',
            'status' => 'required|in:active,inactive',
        ];

        $validator = \Validator::make($request->all(), $rules);


        if ($validator->fails()) {
            return response()->json([
                'success' => false,
                'message' => 'Validation error',
                'errors' => $validator->errors()
            ]);
        }

        $user = auth()->user();

        $data = $validator->validated();

        $coupon->update(
            [
                ...$data,
                'updatedBy' => $user->id,
            ],
        );

        return response()->json([
            'success' => true,
            'data' => $coupon,
        ]);

    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Coupon $coupon): JsonResponse
    {
        $coupon->delete();

        return response()->json([
            'success' => true,
            'message' => 'Coupon deleted successfully',
        ]);
    }
}
