<?php

namespace App\Http\Controllers;

use App\Models\ConfigVariable;
use Illuminate\Http\Request;

class ConfigVariableController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        //
        $configVariables = ConfigVariable::all();

        return response()->json([
            'success' => true,
            'data' => $configVariables,
        ]);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
        $rules = [
            'name' => 'required|unique:config_variables',
            'value' => 'required',
        ];

        $validator = \Validator::make($request->all(), $rules);

        if ($validator->fails()) {
            return response()->json([
                'success' => false,
                'message' => 'Validation error',
                'errors' => $validator->errors()
            ]);
        }

        $data = $validator->validated();

        $configVariables = ConfigVariable::create($data);

        return response()->json([
            'success' => true,
            'data' => $configVariables,
        ]);

    }

    /**
     * Display the specified resource.
     */
    public function show(ConfigVariable $configVariables)
    {

        return response()->json([
            'success' => true,
            'data' => $configVariables,
        ]);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, ConfigVariable $configVariable)
    {


        $rules = [
            'name' => 'required|unique:config_variables,name,' . $configVariable->id,
            'value' => 'required',
        ];

        $data = $this->validate($request, $rules);

        $configVariable->update($data);


        return response()->json([
            'success' => true,
            'data' => $configVariable,
        ]);
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(ConfigVariable $configVariables)
    {

        $configVariables->delete();

        return response()->json([
            'success' => true,
            'data' => $configVariables,
        ]);
    }
}
