<?php

namespace App\Http\Controllers;

use App\Models\Color;
use Illuminate\Http\Request;

class ColorController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $colors = Color::all();

        return response()->json([
            'success' => true,
            'data' => $colors,
        ], 200);
    }

    public function indexPublic()
    {
        $colors = Color::all();

        return response()->json([
            'success' => true,
            'data' => $colors,
        ], 200);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $rules = [
            'name' => 'required|string',
            'code' => 'required|string',
        ];

        $validator = \Validator::make($request->input(), $rules);

        if ($validator->fails()) {
            return response()->json([
                'success' => false,
                'message' => 'Validation error',
                'errors' => $validator->errors()
            ], 400);
        }

        $data = $validator->validated();


        $colors = Color::create($data);

        return response()->json([
            'success' => true,
            'data' => $colors,
        ], 201);
    }

    /**
     * Display the specified resource.
     */
    public function show(Color $color)
    {
        return response()->json([
            'success' => true,
            'data' => $color,
        ]);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, Color $color)
    {
        $rules = [
            'name' => 'required|string',
            'code' => 'required|string',
        ];

        $validator = \Validator::make($request->input(), $rules);

        if ($validator->fails()) {
            return response()->json([
                'success' => false,
                'message' => 'Validation error',
                'errors' => $validator->errors()
            ], 400);
        }

        $data = $validator->validated();

        $color->update($data);

        return response()->json([
            'success' => true,
            'data' => $color,
        ], 200);
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Color $color)
    {
        $deleted = $color->delete();
        $responseCode = $deleted ? 200 : 404;
        $message = $deleted ? 'Color deleted' : 'Color not found';
        $success = $deleted ? true : false;

        return response()->json(
            [
                'success' => $success,
                "message" => $message,
                'data' => $color,
            ],
            $responseCode
        );
    }
}